/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.vterm;

import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.util.HardwareServerMessage;
import com.ibm.hsc.vterm.PIHSCVtermHelper;
import com.ibm.hsc.vterm.PIHSCVtermReader;
import com.ibm.hsc.vterm.VSerialHelper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.net.InetAddress;
import java.net.Socket;
import java.sql.Timestamp;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class PIHSCVtermPacketThread
implements Runnable {
    Socket socket = null;
    String hostName = "";
    String port = "";
    String cfgString = "";
    String lparId = "";
    String sessionId = "";
    short _lparId;
    short _sessionId;
    int vport;
    boolean XON = false;
    DataInputStream vterminsoc = null;
    DataOutputStream vtermoutsoc = null;
    boolean openTerm = false;
    boolean noStrip = false;
    boolean debugOn = false;
    public static boolean bufferFull = false;
    RandomAccessFile outFile = null;
    FileWriter fwriter = null;
    PrintWriter pwriter = null;
    boolean logit = false;
    boolean forceit = false;
    boolean openQuery = false;
    boolean alreadyOpen = false;
    VSerialHelper helper = null;

    public PIHSCVtermPacketThread(Socket socket) {
        this.socket = socket;
    }

    public void run() {
        byte[] byArray = new byte[32];
        byte[] byArray2 = new byte[32];
        boolean bl = false;
        PIHSCVtermReader pIHSCVtermReader = null;
        File file = new File("/var/hsc/log/.DEBUG_VTERM");
        if (file.exists()) {
            this.debugOn = true;
        }
        try {
            this.vterminsoc = new DataInputStream(this.socket.getInputStream());
            this.vtermoutsoc = new DataOutputStream(this.socket.getOutputStream());
            this.getInitData();
            File file2 = new File("/tmp/" + this.lparId + "*" + this.cfgString);
            if (file2.exists()) {
                this.logit = true;
                if (file2.length() > 0L) {
                    try {
                        file2.renameTo(new File("/tmp/" + this.lparId + "*" + this.cfgString + ".bak"));
                        file2.delete();
                        file2 = new File("/tmp/" + this.lparId + "*" + this.cfgString);
                        file2.createNewFile();
                    }
                    catch (IOException iOException) {
                        this.logit = false;
                    }
                }
            }
            if (this.logit) {
                try {
                    this.outFile = new RandomAccessFile(file2, "rw");
                    this.fwriter = new FileWriter(this.outFile.getFD());
                    this.pwriter = new PrintWriter((Writer)this.fwriter, true);
                    this.pwriter.println("\r\nStart of session\r\n");
                }
                catch (IOException iOException) {
                    this.logit = false;
                }
            }
            if (!this.forceit) {
                pIHSCVtermReader = new PIHSCVtermReader(this);
            }
            if (this.debugOn) {
                System.out.println(this.cfgString + " lparid:" + this.lparId + " connecting to a hardware server at: " + this.hostName);
            }
            this.helper = PIHSCVtermHelper.getInst(this.hostName);
            this.vport = this.getVPort(this.cfgString, this.helper);
            if (this.vport == -1) {
                throw new Exception("Invalid CEC Name - No VPORT found");
            }
            if (this.forceit) {
                if (this.debugOn) {
                    System.out.println(this.cfgString + "lparid:" + this.lparId + " Setting force close flag sending close request");
                }
                this.helper.close(this.vport, this._lparId, this._sessionId, true);
                this.cleanup();
                return;
            }
            if (this.openQuery) {
                if (this.alreadyOpen) {
                    this.vtermoutsoc.writeByte(49);
                    if (this.debugOn) {
                        System.out.println("in if(openQuery) sending 0x31");
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        System.out.println("EXITING in if(openQuery) in exception");
                    }
                    this.cleanup();
                    return;
                }
                this.vtermoutsoc.writeByte(48);
                if (this.debugOn) {
                    System.out.println("in if(openQuery) sending 0x30");
                }
                this.vtermoutsoc.flush();
                this.openQuery = false;
                this.getInitData();
            } else if (this.alreadyOpen) {
                String string = "\r\n A terminal session is already open for this partition. \r\n Only one open session is allowed for a partition. \r\n Exiting.... ";
                this.vtermoutsoc.writeChars(string);
                this.vtermoutsoc.flush();
                this.Sleep(10000);
                this.cleanup();
                return;
            }
            for (int i = 0; i < 3; ++i) {
                pIHSCVtermReader.setOpenCount(i + 1);
                this.helper.open(this.vport, this._lparId, this._sessionId, (short)1, pIHSCVtermReader);
                while (pIHSCVtermReader.getState() != 3 && pIHSCVtermReader.getState() != 4) {
                    this.Sleep(200);
                }
                if (pIHSCVtermReader.getState() == 3) break;
                this.Sleep(500);
            }
            pIHSCVtermReader.setOpenCount(0);
            if (this.debugOn) {
                System.out.println(this.cfgString + " lparid:" + this.lparId + " Open done: vport=" + this.vport);
            }
            byte[] byArray3 = new byte[]{13, 10};
            this.helper.write(this.vport, this._lparId, this._sessionId, byArray3, 2);
            while (true) {
                int n;
                if ((n = this.vterminsoc.read(byArray, 0, 32)) > 0) {
                    int n2;
                    int n3;
                    if (this.debugOn) {
                        System.out.print(new Timestamp(System.currentTimeMillis()));
                        System.out.println(" " + this.cfgString + " " + this.lparId + " From Terminal ");
                        for (n3 = 0; n3 < n; ++n3) {
                            System.out.print((char)byArray[n3] + " ");
                        }
                        System.out.println("");
                    }
                    int n4 = n;
                    for (n2 = 0; n2 < n; ++n2) {
                        if (byArray[n2] != 10) continue;
                        --n4;
                    }
                    if (n4 != n && !this.noStrip) {
                        int n5 = 0;
                        for (n2 = 0; n2 < n; ++n2) {
                            if (byArray[n2] == 10) continue;
                            byArray2[n5] = byArray[n2];
                            ++n5;
                        }
                    } else {
                        for (n2 = 0; n2 < n; ++n2) {
                            byArray2[n2] = byArray[n2];
                        }
                    }
                    do {
                        if (bufferFull) {
                            this.unSetWait();
                            Thread.sleep(1L);
                            if (this.debugOn) {
                                System.out.println(this.cfgString + " lparid:" + this.lparId + " Bufferfull: SLEEP");
                            }
                        }
                        if (pIHSCVtermReader.getState() != 4) {
                            this.helper.write(this.vport, this._lparId, this._sessionId, byArray2, n4);
                        } else if (this.debugOn) {
                            System.out.print("Writer: In error state, packet not written");
                        }
                        if (this.debugOn) {
                            System.out.print(new Timestamp(System.currentTimeMillis()));
                            System.out.print(" " + this.cfgString + " " + this.lparId + " TO CSP: ");
                            for (n3 = 0; n3 < n4; ++n3) {
                                System.out.print((char)byArray2[n3]);
                            }
                            System.out.println("");
                        }
                        if (!bufferFull) continue;
                        this.unSetWait();
                        Thread.sleep(1L);
                        if (!this.debugOn) continue;
                        System.out.println(this.cfgString + " lparid:" + this.lparId + " Bufferfull: SLEEP");
                    } while (bufferFull);
                    continue;
                }
                if (this.debugOn) {
                    System.out.println(this.cfgString + "lparid:" + this.lparId + " bytesRead = " + n + " EXITING");
                }
                if (n == -1) break;
            }
            if (pIHSCVtermReader.currentState != 1 && this.helper != null) {
                if (this.debugOn) {
                    System.out.println(this.cfgString + " lparid:" + this.lparId + " Closing session3 : vport " + this.vport);
                }
                this.helper.close(this.vport, this._lparId, this._sessionId, false);
            }
            this.cleanup();
            return;
        }
        catch (Exception exception) {
            if (this.debugOn) {
                System.out.println(this.cfgString + "lparid:" + this.lparId + " Writer caught " + exception);
                System.out.println(this.cfgString + "lparid:" + this.lparId + " leaving vtty passthrough.  state = " + pIHSCVtermReader.currentState);
            }
            if (this.helper != null) {
                if (this.debugOn) {
                    System.out.println(this.cfgString + "lparid:" + this.lparId + " Closing session1 : vport " + this.vport);
                }
                this.helper.close(this.vport, this._lparId, this._sessionId, false);
            } else if (this.debugOn) {
                System.out.println(this.cfgString + "lparid:" + this.lparId + " helper == null Did not issue a close");
            }
            this.cleanup();
            return;
        }
    }

    private void Sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void getInitData() {
        int n = 0;
        byte[] byArray = new byte[1];
        try {
            while (n < 4) {
                this.vterminsoc.readFully(byArray);
                if (this.debugOn) {
                    System.out.println("Reading connect chars " + byArray[0]);
                }
                if (byArray[0] == 70) {
                    if (++n != 4) continue;
                    break;
                }
                if (byArray[0] == 65) {
                    if (n != 3) continue;
                    this.forceit = true;
                    if (!this.debugOn) break;
                    System.out.println("Setting force close flag");
                    break;
                }
                if (byArray[0] == 88) {
                    if (n != 3) continue;
                    this.openTerm = true;
                    break;
                }
                if (byArray[0] == 90) {
                    if (n != 3) continue;
                    this.noStrip = true;
                    break;
                }
                if (byArray[0] == 81) {
                    if (n != 3 || this.openQuery) continue;
                    System.out.println("Got QUERY set openQuery = true");
                    this.openQuery = true;
                    break;
                }
                n = 0;
                System.out.println(" set index to " + n);
            }
            n = 0;
            byte[] byArray2 = new byte[16];
            for (n = 0; n < 16; ++n) {
                this.vterminsoc.readFully(byArray);
                if (byArray[0] == 42) break;
                byArray2[n] = byArray[0];
            }
            String string = new String(byArray2, 0, n++);
            Integer n2 = new Integer(string);
            byte[] byArray3 = new byte[n2.intValue()];
            this.vterminsoc.readFully(byArray3);
            String string2 = new String(byArray3);
            if (this.debugOn) {
                System.out.println("NEW session datastring =" + string2);
            }
            this.getCmdData(string2);
        }
        catch (Exception exception) {
            if (this.debugOn) {
                System.out.println(this.cfgString + "lparid:" + this.lparId + " Writer:getInitData caught " + exception);
            } else if (this.debugOn) {
                System.out.println(this.cfgString + "lparid:" + this.lparId + " Error connecting to hardware server.");
            }
            this.cleanup();
            return;
        }
    }

    public void cleanup() {
        try {
            if (this.vterminsoc != null) {
                this.vterminsoc.close();
                this.vterminsoc = null;
            }
            if (this.vtermoutsoc != null) {
                this.vtermoutsoc.close();
                this.vtermoutsoc = null;
            }
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void getCmdData(String string) {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "*";
        StringTokenizer stringTokenizer = new StringTokenizer(string, "*", true);
        try {
            this.hostName = stringTokenizer.nextToken();
            this.port = stringTokenizer.nextToken();
            if (this.port.equals(string6)) {
                this.port = stringTokenizer.nextToken();
            }
            if ((this.lparId = stringTokenizer.nextToken()).equals(string6)) {
                this.lparId = stringTokenizer.nextToken();
                this._lparId = Short.parseShort(this.lparId);
            }
            if ((string2 = stringTokenizer.nextToken()).equals(string6)) {
                string2 = stringTokenizer.nextToken();
            }
            if ((string3 = stringTokenizer.nextToken()).equals(string6)) {
                string3 = stringTokenizer.nextToken();
            }
            if ((this.sessionId = stringTokenizer.nextToken()).equals(string6)) {
                this.sessionId = stringTokenizer.nextToken();
                this._sessionId = Short.parseShort(this.sessionId);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        if (this.debugOn) {
            System.out.println(this.cfgString + "lparid:" + this.lparId + " getCmdData: port " + this.port);
            System.out.println(this.cfgString + "lparid:" + this.lparId + " getCmdData: lparId " + this._lparId);
            System.out.println(this.cfgString + "lparid:" + this.lparId + " getCmdData: sessionId " + this._sessionId);
            System.out.println(this.cfgString + "lparid:" + this.lparId + " getCmdData: model " + string2);
            System.out.println(this.cfgString + "lparid:" + this.lparId + " getCmdData: serial " + string3);
            System.out.println(this.cfgString + "lparid:" + this.lparId + " getCmdData: hostName " + this.hostName);
        }
        this.cfgString = string3.equals(string6) ? string2 + "*" : string2 + "*" + string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int getVPort(String string, VSerialHelper vSerialHelper) throws PIHscClientException {
        int n;
        block23: {
            DataOutputStream dataOutputStream;
            DataInputStream dataInputStream;
            Socket socket;
            block22: {
                int n2;
                int n3;
                int n4;
                byte[] byArray;
                block21: {
                    n = -1;
                    Object var4_4 = null;
                    socket = null;
                    dataInputStream = null;
                    dataOutputStream = null;
                    if (this.debugOn) {
                        System.out.println("lparid:" + this.lparId + " In getVPort , mtms = " + string);
                    }
                    while (socket == null) {
                        try {
                            socket = new Socket(InetAddress.getLocalHost(), 8877);
                            dataInputStream = new DataInputStream(socket.getInputStream());
                            dataOutputStream = new DataOutputStream(socket.getOutputStream());
                        }
                        catch (IOException iOException) {
                            if (this.debugOn) {
                                System.out.println("lparid:" + this.lparId + " Connection failed to hardware server.  Trying again...");
                            }
                            this.Sleep(10000);
                        }
                    }
                    HardwareServerMessage hardwareServerMessage = HardwareServerMessage.buildHSFspQuery();
                    byte[] byArray2 = hardwareServerMessage.toBytes();
                    dataOutputStream.write(byArray2, 0, byArray2.length);
                    dataOutputStream.flush();
                    hardwareServerMessage = new HardwareServerMessage(dataInputStream);
                    byArray = hardwareServerMessage.toBytes();
                    int n5 = (((byArray[7] & 0xFF) << 8) + (byArray[6] & 0xFF)) / 4;
                    if (this.debugOn) {
                        System.out.println("lparid:" + this.lparId + " getVPORT numCecs: " + n5);
                    }
                    long[] lArray = new long[n5];
                    for (n4 = 0; n4 < n5; ++n4) {
                        n3 = 30 + n4 * 4;
                        lArray[n4] = (((long)byArray[n3 + 3] & 0xFFL) << 24) + (((long)byArray[n3 + 2] & 0xFFL) << 16) + (((long)byArray[n3 + 1] & 0xFFL) << 8) + ((long)byArray[n3] & 0xFFL);
                    }
                    for (n4 = 0; n4 < lArray.length; ++n4) {
                        hardwareServerMessage = HardwareServerMessage.buildFspDataQuery((int)lArray[n4]);
                        byArray2 = hardwareServerMessage.toBytes();
                        dataOutputStream.write(byArray2, 0, byArray2.length);
                        dataOutputStream.flush();
                        hardwareServerMessage = new HardwareServerMessage(dataInputStream);
                        byArray = hardwareServerMessage.toBytes();
                        n3 = ((byArray[31] & 0xFF) << 8) + (byArray[30] & 0xFF);
                        n2 = byArray[30 + n3 - 2];
                        String string2 = new String(byArray, 30 + n3, n2);
                        byte by = byArray[30 + n3 + n2 + 32];
                        if (!string2.trim().equalsIgnoreCase(string.trim()) || by != 1) continue;
                        n = (int)lArray[n4];
                        System.out.println("lparid:" + this.lparId + " getVPORT CEC vport: " + n);
                        System.out.println("lparid:" + this.lparId + " getVPORT CEC vty vport : " + ++n);
                        break;
                    }
                    hardwareServerMessage = HardwareServerMessage.buildVserialListRequest(n, 0);
                    byArray2 = hardwareServerMessage.toBytes();
                    dataOutputStream.write(byArray2, 0, byArray2.length);
                    dataOutputStream.flush();
                    hardwareServerMessage = new HardwareServerMessage(dataInputStream);
                    byArray = hardwareServerMessage.getPayload();
                    if (this.debugOn) {
                        System.out.println("hsbytes.len " + byArray.length);
                        for (n4 = 0; n4 < byArray.length; ++n4) {
                            System.out.print(byArray[n4]);
                        }
                        System.out.println();
                    }
                    if (byArray.length >= 4) {
                        n4 = HardwareServerMessage.bytesToUShort(byArray, 0);
                        n3 = byArray[2];
                        System.out.println("maxCecConnections:" + n4 + "  maxPerPartition:" + n3);
                    }
                    if (byArray.length != 4) break block21;
                    if (!this.debugOn) break block22;
                    System.out.println("Get open sessions: no data to return");
                    break block22;
                }
                for (n4 = 4; n4 < byArray.length; n4 += 8) {
                    n3 = HardwareServerMessage.bytesToUShort(byArray, n4);
                    n2 = HardwareServerMessage.bytesToUShort(byArray, n4 + 2);
                    System.out.println("open session pid=" + n3 + " sid=" + n2);
                    if (this._lparId != n3 || n2 != 0) continue;
                    if (this.debugOn) {
                        System.out.println("set alreadyOpen = true");
                    }
                    this.alreadyOpen = true;
                    break;
                }
            }
            Object var19_20 = null;
            try {
                socket.close();
                socket = null;
                dataInputStream.close();
                dataOutputStream.close();
            }
            catch (IOException iOException) {}
            break block23;
            {
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    Object var19_21 = null;
                    try {
                        socket.close();
                        socket = null;
                        dataInputStream.close();
                        dataOutputStream.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var19_22 = null;
                try {
                    socket.close();
                    socket = null;
                    dataInputStream.close();
                    dataOutputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return n;
    }

    public static void setWait() {
        bufferFull = true;
    }

    public void unSetWait() {
        bufferFull = false;
    }
}

